/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.block.MCBlockState;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.client.TFCSounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.terrafirmacraft.fallingblock.FallingBlockManager")
public class CTFallingBlockManager {
    @ZenMethod
    public static void registerFallable(crafttweaker.api.block.IBlockState state, CTSpecification ctSpecification) {
        FallingBlockManager.registerFallable((IBlockState)state.getInternal(), ctSpecification.internalSpec);
    }

    @ZenMethod
    public static void registerFallable(crafttweaker.api.block.IBlockState state, crafttweaker.api.block.IBlockState existingState) {
        FallingBlockManager.Specification existingSpec = FallingBlockManager.getSpecification((IBlockState)existingState.getInternal());
        if (existingSpec == null) {
            throw new IllegalArgumentException(existingState + " is not in the current specification definitions.");
        }
        FallingBlockManager.registerFallable((IBlockState)state.getInternal(), existingSpec);
    }

    @ZenMethod
    public static void registerFallable(IBlockDefinition block, CTSpecification ctSpecification) {
        FallingBlockManager.registerFallable((Block)block.getInternal(), ctSpecification.internalSpec);
    }

    @ZenMethod
    public static void registerFallable(IBlockDefinition block, crafttweaker.api.block.IBlockState existingState) {
        FallingBlockManager.Specification existingSpec = FallingBlockManager.getSpecification((IBlockState)existingState.getInternal());
        if (existingSpec == null) {
            throw new IllegalArgumentException(existingState + " is not in the current specification definitions.");
        }
        FallingBlockManager.registerFallable((Block)block.getInternal(), existingSpec);
    }

    @ZenMethod
    public static void registerFallable(String blockId, CTSpecification ctSpecification) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        if (block == null) {
            throw new IllegalArgumentException(blockId + " is not a valid Block.");
        }
        FallingBlockManager.registerFallable(block, ctSpecification.internalSpec);
    }

    @ZenMethod
    public static void registerFallable(String blockId, crafttweaker.api.block.IBlockState existingState) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        if (block == null) {
            throw new IllegalArgumentException(blockId + " is not a valid Block.");
        }
        FallingBlockManager.Specification existingSpec = FallingBlockManager.getSpecification((IBlockState)existingState.getInternal());
        if (existingSpec == null) {
            throw new IllegalArgumentException(existingState + " is not in the current specification definitions.");
        }
        FallingBlockManager.registerFallable(block, existingSpec);
    }

    @ZenMethod
    public static void registerSideSupport(crafttweaker.api.block.IBlockState state) {
        FallingBlockManager.registerSideSupports((IBlockState)state.getInternal());
    }

    @ZenMethod
    public static void registerSideSupport(IBlockDefinition block) {
        FallingBlockManager.registerSideSupports((Block)block.getInternal());
    }

    @ZenMethod
    public static void registerSideSupport(String blockId) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        if (block == null) {
            throw new IllegalArgumentException(blockId + " is not a valid Block.");
        }
        FallingBlockManager.registerSideSupports(block);
    }

    @ZenRegister
    @ZenClass(value="mods.terrafirmacraft.fallingblock.Specification")
    public static class CTSpecification {
        final FallingBlockManager.Specification internalSpec;

        @ZenMethod
        public static CTSpecification create(boolean canFallHorizontally, boolean canCaveIn) {
            return new CTSpecification(canFallHorizontally, canCaveIn, () -> TFCSounds.ROCK_SLIDE_SHORT);
        }

        @ZenMethod
        public static CTSpecification create(boolean canFallHorizontally, boolean canCaveIn, String soundEventId, @Optional ICTFallDropsProvider dropsProvider) {
            return new CTSpecification(canFallHorizontally, canCaveIn, new ResourceLocation(soundEventId), dropsProvider);
        }

        @ZenMethod
        public static CTSpecification get(crafttweaker.api.block.IBlockState state) {
            FallingBlockManager.Specification spec = FallingBlockManager.getSpecification((IBlockState)state.getInternal());
            return spec == null ? null : new CTSpecification(spec);
        }

        private static FallingBlockManager.Specification.IFallDropsProvider transform(ICTFallDropsProvider ctProvider) {
            return (world, pos, state, teData, fallTime, fallDistance) -> {
                IItemStack[] drops = ctProvider.getDropsFromFall(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos), CraftTweakerMC.getBlockState((IBlockState)state), CraftTweakerMC.getIData((NBTBase)teData), fallTime, fallDistance);
                ArrayList<ItemStack> iterableDrops = new ArrayList<ItemStack>(drops.length);
                for (IItemStack drop : drops) {
                    iterableDrops.add((ItemStack)drop.getInternal());
                }
                return iterableDrops;
            };
        }

        CTSpecification(FallingBlockManager.Specification internalSpec) {
            this.internalSpec = internalSpec;
        }

        CTSpecification(boolean canFallHorizontally, boolean canCaveIn, ResourceLocation soundEventId) {
            this(canFallHorizontally, canCaveIn, () -> (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)soundEventId));
        }

        CTSpecification(boolean canFallHorizontally, boolean canCaveIn, Supplier<SoundEvent> soundEvent) {
            this.internalSpec = new FallingBlockManager.Specification(canFallHorizontally, canCaveIn, soundEvent, FallingBlockManager.Specification.DEFAULT_DROPS_PROVIDER);
        }

        CTSpecification(boolean canFallHorizontally, boolean canCaveIn, ResourceLocation soundEventId, ICTFallDropsProvider dropsProvider) {
            this(canFallHorizontally, canCaveIn, () -> (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)soundEventId), dropsProvider);
        }

        CTSpecification(boolean canFallHorizontally, boolean canCaveIn, Supplier<SoundEvent> soundEvent, ICTFallDropsProvider drops) {
            this.internalSpec = new FallingBlockManager.Specification(canFallHorizontally, canCaveIn, soundEvent, CTSpecification.transform(drops));
        }

        @ZenMethod
        public void setResultingBlock(IBlockDefinition block) {
            this.internalSpec.setResultingState(((Block)block.getInternal()).func_176223_P());
        }

        @ZenMethod
        public void setResultingBlock(String blockId) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
            if (block == null) {
                throw new IllegalArgumentException(blockId + " is not a valid Block.");
            }
            this.internalSpec.setResultingState(block.func_176223_P());
        }

        @ZenMethod
        public void setResultingState(crafttweaker.api.block.IBlockState block) {
            this.internalSpec.setResultingState((IBlockState)block.getInternal());
        }

        @ZenMethod
        public void whenBeginningFall(ICTBeginFallCallback beginFall) {
            this.internalSpec.setBeginFallCallback((world, pos) -> beginFall.beginFall(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos)));
        }

        @ZenMethod
        public void whenEndingFall(ICTEndFallCallback endFall) {
            this.internalSpec.setEndFallCallback((world, pos) -> endFall.endFall(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos)));
        }

        @ZenMethod
        public void whenCavingIn(ICTCollapseChecker collapseChecker) {
            if (!this.internalSpec.isCollapsable()) {
                throw new IllegalArgumentException("This specification does not allow for cave-ins!");
            }
            this.internalSpec.setCollapseCondition((world, pos) -> collapseChecker.canCollapse(CraftTweakerMC.getIWorld((World)world), CraftTweakerMC.getIBlockPos((BlockPos)pos)));
        }

        @ZenMethod
        public boolean canFallHorizontally() {
            return this.internalSpec.canFallHorizontally();
        }

        @ZenMethod
        public boolean canCaveIn() {
            return this.internalSpec.isCollapsable();
        }

        @ZenMethod
        public crafttweaker.api.block.IBlockState getCustomResultingState() {
            if (this.internalSpec.getResultingState() == null) {
                return null;
            }
            return new MCBlockState(this.internalSpec.getResultingState());
        }

        @ZenRegister
        @FunctionalInterface
        @ZenClass(value="mods.terrafirmacraft.fallingblock.CollapseChecker")
        public static interface ICTCollapseChecker {
            public boolean canCollapse(IWorld var1, IBlockPos var2);
        }

        @ZenRegister
        @FunctionalInterface
        @ZenClass(value="mods.terrafirmacraft.fallingblock.EndFallCallback")
        public static interface ICTEndFallCallback {
            public void endFall(IWorld var1, IBlockPos var2);
        }

        @ZenRegister
        @FunctionalInterface
        @ZenClass(value="mods.terrafirmacraft.fallingblock.BeginFallCallback")
        public static interface ICTBeginFallCallback {
            public void beginFall(IWorld var1, IBlockPos var2);
        }

        @ZenRegister
        @FunctionalInterface
        @ZenClass(value="mods.terrafirmacraft.fallingblock.FallDropsProvider")
        public static interface ICTFallDropsProvider {
            public IItemStack[] getDropsFromFall(IWorld var1, IBlockPos var2, crafttweaker.api.block.IBlockState var3, IData var4, int var5, float var6);
        }
    }
}

